//
//  MCMergeTokenInspectorRegistry.h
//  TokenMergeTest
//
//  Created by Alykhan Jetha on 02/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCMergeTokenInspectorView;

@interface MCMergeTokenInspectorRegistry : NSObject {
	NSMutableDictionary *tokenInspectorsRegistry;
}

+ (MCMergeTokenInspectorRegistry *)defaultTokenInspectorRegistry;
+ (void)registerTokenInspectorName:(NSString *)aName forProcessorClassName:(NSString *)aClassName;

+ (NSArray *)tokenInspectorNames;

- (NSArray *)tokenInspectorNames;

- (NSMutableDictionary *)tokenInspectorsRegistry;
- (void)setTokenInspectorsRegistry:(NSMutableDictionary *)aTokenInspectorsRegistry;

- (void)setTokenInspectorName:(NSString *)aName forProcessorClassName:(NSString *)aClassName;
- (void)removeTokenInspectorForProcessorClassName:(NSString *)aName;

- (MCMergeTokenInspectorView *)inspectorViewForProcessorClassName:(NSString *)aClassName;

@end
